(function () {
    'use strict';
    let totalMessagesTracked = 0;

    function formatDuration(seconds) {
        if (seconds < 60) {
            return `${seconds}s`;
        }
        const minutes = Math.floor(seconds / 60);
        const remainingSeconds = seconds % 60;
        return `${minutes}:${remainingSeconds.toString().padStart(2, '0')}`;
    }

    const originalOpen = XMLHttpRequest.prototype.open;
    XMLHttpRequest.prototype.open = function (method, url, async, user, password) {
        this._url = url;
        return originalOpen.apply(this, arguments);
    };
    
    const originalSend = XMLHttpRequest.prototype.send;
    XMLHttpRequest.prototype.send = function (...args) {
        this.addEventListener('load', function () {
            if (!this._url || !this._url.includes('/api2/v2/chats')) return;
            try {
                const json = JSON.parse(this.responseText);
                if (!json?.list) return;
                const apiMessages = json.list.slice().reverse();
                setTimeout(() => {
                    const wrapper = document.querySelector('.b-chat__messages-wrapper');
                    if (!wrapper) return;
                    
                    const domMessages = wrapper.querySelectorAll('[at-attr="chat_message"]');
                    const baseIndex = Math.max(0, domMessages.length - (totalMessagesTracked + apiMessages.length));
                    
                    apiMessages.forEach((msg, i) => {
                        if (!msg.media || msg.media.length === 0) return;

                        const videoDurations = msg.media
                            .filter(m => m.type === 'video' && m.duration > 0 && m.canView === false)
                            .map(m => ({ duration: m.duration, id: m.id }));

                        if (videoDurations.length >= 1) {
                            const domIndex = baseIndex + i;
                            const domMessage = domMessages[domIndex];
                            if (domMessage) {
                                if (domMessage.querySelector('.video-info-display')) return;

                                const infoContainer = document.createElement('div');
                                infoContainer.className = 'video-info-display';
                                infoContainer.style.cssText = 'margin-top: 8px; font-family: monospace; font-size: 11px;';

                                const gridContainer = document.createElement('div');
                                gridContainer.style.cssText = 'display: grid; grid-template-columns: repeat(auto-fill, minmax(180px, 1fr)); gap: 8px;';

                                videoDurations.forEach((video, index) => {
                                    const videoCard = document.createElement('div');
                                    videoCard.style.cssText = 'background: rgba(0, 165, 223, 0.15); border: 1px solid #00A5DF; border-left: 3px solid #00A5DF; padding: 8px 10px; border-radius: 6px;';

                                    const headerLine = document.createElement('div');
                                    headerLine.style.cssText = 'display: flex; align-items: center; gap: 6px; margin-bottom: 4px;';

                                    const numberBadge = document.createElement('span');
                                    numberBadge.style.cssText = 'background: #00A5DF; color: #000; font-weight: bold; padding: 2px 6px; border-radius: 3px; font-size: 10px;';
                                    numberBadge.textContent = index + 1;

                                    const durationSpan = document.createElement('span');
                                    durationSpan.style.cssText = 'color: #00A5DF; font-weight: bold; font-size: 12px;';
                                    durationSpan.textContent = formatDuration(video.duration);

                                    headerLine.appendChild(numberBadge);
                                    headerLine.appendChild(durationSpan);

                                    const idLine = document.createElement('div');
                                    idLine.style.cssText = 'color: #999; font-size: 10px;';
                                    idLine.textContent = `ID: ${video.id}`;

                                    videoCard.appendChild(headerLine);
                                    videoCard.appendChild(idLine);
                                    gridContainer.appendChild(videoCard);
                                });

                                infoContainer.appendChild(gridContainer);
                                domMessage.appendChild(infoContainer);
                            }
                        }
                    });
                    totalMessagesTracked += apiMessages.length;
                }, 500);
            } catch (e) {
                console.error('❌ Parse error:', e);
            }
        });
        return originalSend.apply(this, args);
    };
})();

